(*| 16:15 24/10/1994 *)
UNIT CatUtils;

INTERFACE

USES Dos;

CONST
  MaxDir=15700;

VAR
  ChosenDrive,ThisDirName,FileBody,FileExt,FloppyName: PathStr;
  FindRec: SearchRec;
  FindDirRec: ARRAY [1..6] OF SearchRec;
  FileSpec,OptionString,OriginalPath,DestPath,TextLine: PathStr;
  ListFileName: PathStr;
  I,DriveNum,Level,NumOfFiles,NumOfListFiles,FilesInThisDir: Integer;
  FloppyNum: Integer;
  NumOfArcFiles,NumOfZipFiles,NumOfLzhFiles,NumOfArjFiles: Integer;
  Abort,Print,Sort,SaveToFile,Floppy,ShowDT,Quiet,CurAndSub,Append: Boolean;
  ThreeWide,LastResultOK,ByExt,OtherMode,Update,NoArc: Boolean;
  FindDir,FoundFile,FoundInWhere: Boolean;
  C:Char;
  ListFile:TEXT;
  DirData: ARRAY[1..MaxDir] OF ^PathStr;
  MemMark: Pointer;
  AllDirSize,ThisDirSize: LongInt;

FUNCTION IntToString(Num, Width : Integer) : PathStr;

FUNCTION IntToPadString(Num, Width : Integer) : PathStr;

FUNCTION RealToString(Num : Real; Width, Places : Integer) : PathStr;

FUNCTION FixString(FString : PathStr; Len : Byte) : PathStr;

FUNCTION UpperCase(S : PathStr) : PathStr;

FUNCTION FileDateString(Date : DateTime):PathStr;

FUNCTION FileTimeString(Time : DateTime):PathStr;

FUNCTION FileSizeString(Size : LongInt):PathStr;

PROCEDURE ShowHelp;

PROCEDURE ShowSize(Size: LongInt);

PROCEDURE SetFloppyNum;

PROCEDURE ShowWhere(S:String);

FUNCTION ResultOK:Boolean;

PROCEDURE ProcessOptions;

PROCEDURE DeleteOldFloppy;

PROCEDURE AppendFile;

FUNCTION AbortTest: Boolean;

PROCEDURE SortDirData;

PROCEDURE DoFileSave;

PROCEDURE ProcessThisFileText(ThisFileText: PathStr;FDT,FSize: LongInt);

PROCEDURE ProcessThisFile(FileInfo:SearchRec);

PROCEDURE ShowFiles;

FUNCTION CheckFileSpec(FName:PathStr):Boolean;

IMPLEMENTATION

USES Crt,Printer;

FUNCTION IntToString(Num, Width : Integer) : PathStr;
{ Changes an integer into a string }
VAR TempString : PathStr;
BEGIN
  Str(Num:Width, TempString);
  IntToString := TempString;
END; { IntToString }

FUNCTION IntToPadString(Num, Width : Integer) : PathStr;
{ Changes an integer into a string and pads it with a zero on the left if
  it is less than 10 }
BEGIN
  IF Num < 10 THEN
    IntToPadString := '0' + IntToString(Num, Width)
  ELSE
    IntToPadString := IntToString(Num, Width);
END; { IntToString }

FUNCTION RealToString(Num : Real; Width, Places : Integer) : PathStr;
{ Changes a real number into a string }
VAR TempString : PathStr;
BEGIN
  Str(Num:Width:Places, TempString);
  RealToString := TempString;
END; { RealToString }

{ ==================== GENERAL PURPOSE STRING ROUTINES ====================== }
FUNCTION FixString(FString : PathStr; Len : Byte) : PathStr;
{ Makes a string a specified length.  If the string is too long, the extra
  characters will be truncated.  If the string is too short, the string will
  be padded with spaces.
}
var StringLen : byte absolute FString;
                            { Make a variable for FString's length byte }
BEGIN
  IF StringLen > Len THEN
    Delete(FString, Succ(Len), StringLen - Len)
                                    { Delete end of string if it is too long }
  ELSE
    WHILE StringLen < Len DO          { Pad FString with spaces on the right }
      FString := FString + ' ';
  FixString := FString;
END; { FixString }

FUNCTION UpperCase(S : PathStr) : PathStr;
{ Convert a string to all upper case letters }
VAR I : integer;
BEGIN                               { Note that we intentionally modify a    }
  FOR I := 1 to LENGTH(S) DO        { VALUE parameter, and then return that  }
    S[I] := UpCase(S[I]);           { modified value via the function value. }
  UpperCase := S;
END; { UpperCase }

FUNCTION FileDateString(Date : DateTime):PathStr;
BEGIN
  WITH Date DO
    FileDateString:=IntToString(Day,2) + '/' +
                    IntToPadString(Month,1) + '/' +
                    IntToString(Year,4);
END;  { FileDateString }

FUNCTION FileTimeString(Time : DateTime):PathStr;
BEGIN
  WITH Time DO
    FileTimeString:=IntToString(Hour,2) + ':' +
                    IntToPadString(Min,1);
END;  { FileTimeString }

FUNCTION FileSizeString(Size : LongInt):PathStr;
VAR TempString : PathStr;
BEGIN
  Str(Size:8, TempString);
  FileSizeString := TempString;
END;  { FileSizeString }

PROCEDURE ShowHelp;
BEGIN
  Writeln('Usage    : ');
  Writeln(
    '  CAT [D:][filespec] [DestFileName] [/P][/S][/X][/D][/T][/Q][/A][/3][/O]');
  Writeln;
  Writeln('Switches : /P    Copy output to printer');
  Writeln('           /S    Sort output alphabetically');
  Writeln('           /X    Sort by extension');
  Writeln('           /D    Copy output to disk, default filename CATDIR.TXT');
  Writeln('           /T    Show file date and time');
  Writeln('           /Q    Quiet screen during directory scanning');
  Writeln('           /C    Scan current and subdirectories only');
  Writeln('           /A    Append to existing disk file');
  Writeln('           /3    Output three wide to printer or file');
  Writeln('           /O    Other mode append {Append NOT three wide}');
  Writeln('           /U    Update existing catalogue');
  Writeln('           /E    Expansion of .ARC files inhibited');
  Writeln('           /F    Find directory containing file');
  Writeln;
  Writeln('Free memory ',MaxAvail);
  HALT;
END;  { ShowHelp }

PROCEDURE ShowSize(Size: LongInt);
BEGIN
  Write(Size:8,' bytes ');
  IF (Quiet AND Print) THEN
    Write(LST,Size:8,' bytes ');
END;  { ShowSize }

PROCEDURE SetFloppyNum;
VAR
  I,Result: Integer;
BEGIN
  VAL(FloppyName,I,Result);
  IF Result <> 0 THEN
    INC(FloppyNum)
  ELSE BEGIN
    FloppyNum:=I;
    FloppyName:=IntToString(FloppyNum,3);
  END;
END;  { SetFloppyNum }

PROCEDURE ShowWhere(S:String);
BEGIN
  IF NOT Quiet THEN BEGIN
    ClrEol;
    Write(S);
    GotoXY(1,WhereY);
    FoundInWhere:=False;
    IF (NOT Sort) AND Print THEN BEGIN
      Writeln(LST,S);
    END;
    IF (MaxAvail > 80) AND (NOT Sort) AND SaveToFile THEN BEGIN
      INC(NumOfListFiles);
      S:= '---'+S+'---';
      GetMem(DirData[NumOfListFiles],Length(S) + 1);
      DirData[NumOfListFiles]^:=S;
    END;
  END;
END;  { ShowWhere }

FUNCTION ResultOK:Boolean;
VAR
  I:Integer;
BEGIN
  I:=IOResult;
  IF I = 0 THEN
    ResultOK:=True
  ELSE BEGIN
    ResultOK:=False;
    Writeln;
    Writeln('IOError #',I);
  END;
END;  { ResultOK }

PROCEDURE ProcessOptions;
BEGIN
  Print:=False;
  Sort:=False;
  ShowDT:=False;
  Quiet:=False;
  CurAndSub:=False;
  Append:=False;
  ThreeWide:=False;
  ByExt:=False;
  OtherMode:=False;
  Update:=False;
  NoArc:=False;
  FindDir:=False;
  IF POS('/P',OptionString) > 0 THEN Print:=True;
  IF POS('/S',OptionString) > 0 THEN Sort:=True;
  IF POS('/D',OptionString) > 0 THEN SaveToFile:=True;
  IF POS('/T',OptionString) > 0 THEN ShowDT:=True;
  IF POS('/Q',OptionString) > 0 THEN Quiet:=True;
  IF POS('/C',OptionString) > 0 THEN CurAndSub:=True;
  IF POS('/A',OptionString) > 0 THEN BEGIN
    Append:=True;
    SaveToFile:=True;
  END;
  IF POS('/X',OptionString) > 0 THEN BEGIN
    Sort:=True;
    ByExt:=True;
  END;
  IF POS('/3',OptionString) > 0 THEN ThreeWide:=True;
  IF POS('/O',OptionString) > 0 THEN BEGIN
    OtherMode:=True;
    Append:=True;
    SaveToFile:=True;
  END;
  IF POS('/U',OptionString) > 0 THEN BEGIN
    Update:=True;
    Append:=True;
    SaveToFile:=True;
  END;
  IF POS('/E',OptionString) > 0 THEN NoArc:=True;
  IF POS('/F',OptionString) > 0 THEN FindDir:=True;
END; { ProcessOptions }

PROCEDURE DeleteOldFloppy;
VAR
  I,J,P,L: Integer;
  C:Char;
  Found,Delete: Boolean;
BEGIN
  IF NOT Quiet THEN
    Write('Searching ',NumOfFiles,' files ');
  L:=Length(FloppyName);
  C:=FloppyName[L];
  IF ShowDT THEN
    P:=39+L
  ELSE
    P:=13+L;
  Found:=False;
  Delete:=False;
  FOR I:= 1 TO NumOfFiles DO BEGIN
    IF DirData[I]^[P]=C THEN
      IF COPY(DirData[I]^,P-(L-1),L)=FloppyName THEN BEGIN
        IF NOT Found THEN BEGIN
          Found:=True;
          J:=I;
          Write(' Deleting ');
        END;
        Delete:=True;
      END;
    IF Found THEN BEGIN
      IF Delete THEN
        Delete:=False
      ELSE BEGIN
        DirData[J]:=DirData[I];
        INC(J);
      END;
    END;
  END;
  IF NOT Quiet THEN
    IF Found THEN
      Write(NumOfFiles-(J-1),' files');
    Writeln;
  IF Found THEN
    NumOfFiles:=J;
END;  { DeleteOldFloppy }

PROCEDURE AppendFile;

  PROCEDURE ReadOldFile;
  VAR
    ListFileText:PathStr;
    FileText:ARRAY[1..3] OF PathStr;
    NumOnThisLine,I,Index: Integer;
    OldThreeWide: Boolean;
  BEGIN
    OldThreeWide:= ThreeWide XOR OtherMode;
    WHILE NOT EOF(ListFile) DO BEGIN
      Readln(ListFile,ListFileText);
      IF NOT OldThreeWide THEN
        INC(NumOfFiles)
      ELSE FOR I:=1 TO 3 DO BEGIN
        FileText[I]:=COPY(ListFileText,(I*27)-26,27);
        IF Length(FileText[I]) > 0 THEN BEGIN
          NumOnThisLine:=I;
          INC(NumOfFiles);
        END;
      END;
      IF NumOfFiles > MaxDir THEN
        BEGIN
          Writeln('Too many files');
          Abort:=True;
        END
      ELSE IF OldThreeWide THEN
        BEGIN
          FOR I:=1 TO NumOnThisLine DO BEGIN
            ListFileText:=FileText[I];
            WHILE ListFileText[Length(ListFileText)] = ' ' DO
              DELETE(ListFileText,Length(ListFileText),1);
            Index:= NumOfFiles - NumOnThisLine + I;
(*          New(DirData[Index]);*)
            GetMem(DirData[Index],Length(ListFileText) + 1);
            DirData[Index]^:=ListFileText;
          END;
        END
      ELSE BEGIN
        INC(NumOfListFiles);
(*      New(DirData[NumOfListFiles]);*)
        GetMem(DirData[NumOfListFiles],Length(ListFileText) + 1);
        DirData[NumOfListFiles]^:=ListFileText;
      END;
    END;
    Close(ListFile);
  END;

BEGIN
  Assign(ListFile,ListFileName);
{$I-}
  Reset(ListFile);
{$I+}
  IF IOResult=0 THEN
    ReadOldFile
  ELSE
    Writeln('Unable to append to ',ListFileName);
END;  { AppendFile }

FUNCTION AbortTest: Boolean;
VAR
  C:Char;
BEGIN
  IF KeyPressed THEN BEGIN
    C:=ReadKey;
    Writeln('Abort Y/N ? ');
    C:=ReadKey;
    IF UpCase(C) = 'Y' THEN BEGIN
      Abort:=True;
      Writeln('Aborting');
    END;
  END;
  AbortTest:=Abort;
END; { AbortTest }

PROCEDURE SortDirData;
VAR
  I,J,Diff,Pivot : Integer;
  NumOnLine: Integer;
  Noswap: Boolean;

  FUNCTION InOrder(A,B : Integer) : Boolean;
  VAR
    ExtA,ExtB: PathStr;
    P: Integer;
  BEGIN
    IF NOT ByExt THEN
      InOrder:= DirData[A]^ <= DirData[B]^
    ELSE BEGIN
      P:=POS('.',DirData[A]^)+1;
      ExtA:= COPY(DirData[A]^,P,3);
      P:=POS('.',DirData[B]^)+1;
      ExtB:= COPY(DirData[B]^,P,3);
      IF ExtA=ExtB THEN
        InOrder:= DirData[A]^ <= DirData[B]^
      ELSE
        InOrder:= ExtA <= ExtB;
    END;
  END;  {InOrder}

  PROCEDURE Exchange(I,J : Integer);
  {Exchanges pointers I and J in Sortout Array}
  Var Temp : Pointer;
  BEGIN
    Temp := DirData[I];
    DirData[I] := DirData[J];
    DirData[J] := Temp;
  END; {Exchange}

BEGIN
  Writeln('Sorting ',NumOfFiles,' filenames');
  Pivot:= 1;
  WHILE Pivot < NumOfFiles DO Pivot:= Pivot * 2;
  Pivot:= Pivot DIV 2;             {set initial pivot at largest power of 2
                                    below number of items}
  REPEAT
    Diff:= NumOfFiles-Pivot;
    FOR J:= 1 TO Diff DO BEGIN
      I:= J;
      Noswap:= False;
      REPEAT
        IF NOT InOrder(I,I+Pivot) THEN
          Exchange(I,I+pivot)     {if items not in order then swap them}
        ELSE Noswap:= True;
        I:=I-Pivot;               {move I back by pivot value}
      UNTIL (I < 1) OR Noswap;    {repeat until I at start or items in order}
    END;
    Pivot:= Pivot DIV 2;          {reduce pivot by factor of 2}
  UNTIL Pivot < 1;                {until all done}
  IF (NOT Print) AND (NOT SaveToFile) THEN BEGIN
    FOR I:=1 TO NumOfFiles DO
      Writeln(DirData[I]^);
  END;
  IF Print THEN BEGIN
    Writeln('Printing filenames');
    NumOnLine:=0;
(*  Abort:=False;*)
    FOR I:=1 TO NumOfFiles DO
(*    IF AbortTest THEN EXIT;*)
      IF NOT ThreeWide THEN
        Writeln(LST,DirData[I]^)
      ELSE BEGIN
        INC(NumOnLine);
        IF NumOnLine < 3 THEN
          Write(LST,FixString(DirData[I]^,26),' ')
        ELSE BEGIN
          Writeln(LST,DirData[I]^);
          NumOnLine:=0;
        END;
      END;
  END;
END; { SortDirData }

PROCEDURE DoFileSave;
VAR
  NumOnLine: Integer;
BEGIN
  Assign(ListFile,ListFileName);
  Rewrite(ListFile);
  Writeln('Saving Data To ',ListFileName);
  NumOnLine:=0;
  FOR I:=1 TO NumOfListFiles DO
    IF NOT ThreeWide THEN
      Writeln(ListFile,DirData[I]^)
    ELSE BEGIN
      INC(NumOnLine);
      IF NumOnLine < 3 THEN
        Write(ListFile,FixString(DirData[I]^,26),' ')
      ELSE BEGIN
        Writeln(ListFile,DirData[I]^);
        NumOnLine:=0;
      END;
    END;
  Close(ListFile);
END;  { DoFileSave }

PROCEDURE ProcessThisFileText(ThisFileText: PathStr;FDT,FSize: LongInt);
VAR
  DT:DateTime;
BEGIN
  IF ShowDT THEN BEGIN
    UnPackTime(FDT,DT);
    ThisFileText:=ThisFileText + FileTimeString(DT) + ' '
                               + FileDateString(DT) + ' '
                               + FileSizeString(FSize) + ' ';
  END;
  IF Floppy THEN
    ThisFileText:=ThisFileText + FloppyName + ' '
                               + COPY(TextLine,4,50) + ThisDirName
  ELSE
    ThisFileText:=ThisFileText + TextLine + ThisDirName;
  IF NOT Quiet THEN BEGIN
    IF NOT FoundInWhere THEN
      Writeln;
    Writeln(NumOfFiles:5,' ',ThisFileText);
  END;
  IF (NOT Sort) AND Print THEN BEGIN
    IF (NOT Quiet) THEN
      Writeln(LST,ThisFileText);
  END;
  IF (SaveToFile OR Sort) THEN BEGIN
    IF NumOfFiles > MaxDir THEN
      BEGIN
        Writeln('Too many files');
        Abort:=True;
      END
    ELSE IF MaxAvail < 162 THEN
      BEGIN
        Writeln('Insufficient memory');
        Abort:=True;
      END
    ELSE BEGIN
(*      New(DirData[NumOfFiles]);*)
      INC(NumOfListFiles);
      GetMem(DirData[NumOfListFiles],Length(ThisFileText) + 1);
      DirData[NumOfListFiles]^:=ThisFileText;
    END;
  END;
END;  { ProcessThisFileText }

PROCEDURE ProcessThisFile(FileInfo:SearchRec);

BEGIN
  WITH FileInfo DO BEGIN
    INC(NumOfFiles);
    AllDirSize:=AllDirSize + Size;
    ThisDirSize:=ThisDirSize + Size;
    ProcessThisFileText(FixString(Name,12)+' ',Time,Size);
  END;
END; { ProcessThisFile }

PROCEDURE ShowFiles;
BEGIN
  FilesInThisDir:=0;
  ThisDirSize:=0;
  FindFirst(FileSpec,Archive,FindRec);
  WHILE DosError=0 DO BEGIN
    INC(FilesInThisDir);
    ProcessThisFile(FindRec);
    FoundFile:=True;
    FoundInWhere:=True;
    IF FindDir THEN
      HALT;
    FindNext(FindRec);
    IF AbortTest THEN Exit;
  END;
  IF Quiet THEN BEGIN
    ShowSize(ThisDirSize);
    Writeln(TextLine,ThisDirName,' : ',FilesInThisDir,' files');
    IF Print THEN
      Writeln(LST,TextLine,ThisDirName,' : ',FilesInThisDir,' files');
  END;
(*  Writeln;*)
END; { ShowFiles }

FUNCTION CheckFileSpec(FName:PathStr):Boolean;
VAR
  Result:Boolean;
  DotPos: Integer;

  PROCEDURE CheckProc(S,Ref:PathStr);
  VAR
    I,J,LS,LRef: Integer;
  BEGIN
    LS:=Length(S);
    LRef:=Length(Ref);
    I:=0;
    J:=0;
    WHILE Result AND (I < LS) AND (J < LRef) DO BEGIN
      INC(I);
      INC(J);
      IF Ref[J]='*' THEN EXIT;
      IF Ref[J] <> '?' THEN
        Result:=(S[I]=Ref[J]);
    END;
    IF Result THEN
      Result:=(LS=LRef);
  END;

BEGIN
  Result:=True;
  DotPos:=POS('.',FName);
  IF FileSpec <> '*.*' THEN BEGIN
     CheckProc(COPY(FName,DotPos+1,3),FileExt);
     IF Result THEN
       CheckProc(COPY(FName,1,DotPos-1),FileBody);
  END;
  CheckFileSpec:=Result;
END;  { CheckFileSpec }

BEGIN
  FoundFile:=False;
  FoundInWhere:=True;
  FloppyNum:=0;
  AllDirSize:=0;
  NumOfFiles:=0;
  NumOfListFiles:=0;
  NumOfArcFiles:=0;
  NumOfZipFiles:=0;
  NumOfLzhFiles:=0;
  NumOfArjFiles:=0;
END.
